﻿Public Class Form1
    ' vendor and product IDs
    Private Const VendorID As Short = 6017   'Replace with your device's
    Private Const ProductID As Short = 2000  'product and vendor IDs


    ' read and write buffers
    Private Const BufferInSize As Short = 8  'Size of the data buffer coming IN to the PC
    Private Const BufferOutSize As Short = 8 'Size of the data buffer going OUT from the PC
    Dim BufferIn(BufferInSize) As Byte       'Received data will be stored here - the first byte in the array is unused
    Dim BufferOut(BufferOutSize) As Byte     'Transmitted data is stored here - the first item in the array must be 0

    Dim PORTB(8) As Integer

    ' ****************************************************************
    ' when the form loads, connect to the HID controller - pass
    ' the form window handle so that you can receive notification
    ' events...
    '*****************************************************************
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' do not remove!
        ConnectToHID(Me)
        Pictureoff.Visible = True
        Pictureon.Visible = False
        TrackBar1.Enabled = False
        TrackBar2.Enabled = False
        Label8.Text = "AN0"
        Label8.Text = "AN1"
        Label10.Text = "CCP1"
        Label11.Text = "CCP2"
        PictureBox1.Visible = False
        PictureBox3.Visible = False
        PictureBox5.Visible = False
        PictureBox7.Visible = False
        CheckBox1.Enabled = False
        CheckBox2.Enabled = False
        CheckBox3.Enabled = False
        CheckBox4.Enabled = False
        CheckBox5.Enabled = False
        CheckBox6.Enabled = False
        CheckBox7.Enabled = False
        CheckBox8.Enabled = False

        StatusLB2.Text = "Dispositivo USB Desconectado"
    End Sub

    '*****************************************************************
    ' disconnect from the HID controller...
    '*****************************************************************
    Private Sub Form1_FormClosed(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
        Splash.Close()
        DisconnectFromHID()
    End Sub

    '*****************************************************************
    ' a HID device has been plugged in...
    '*****************************************************************
    Public Sub OnPlugged(ByVal pHandle As Integer)
        Dim VendorName As String = "00000000000000000000"
        Dim serial As String = "00000000000000000000"

        If hidGetVendorID(pHandle) = VendorID And hidGetProductID(pHandle) = ProductID Then
            ' ** YOUR CODE HERE **)
            hidGetVendorName(pHandle, VendorName, 20)
            hidGetSerialNumber(pHandle, serial, 20)

            Label1.Text = "Vendor Name: " & VendorName
            Label2.Text = "Product Name: " & ProductName
            Label3.Text = "Vendor ID: " & VendorID
            Label4.Text = "Product ID: " & ProductID
            Label5.Text = "Serial: " & serial
            Pictureoff.Visible = False
            Pictureon.Visible = True
            TrackBar1.Enabled = True
            TrackBar2.Enabled = True
            Label8.Text = Val(BufferIn(1))
            Label8.Text = Val(BufferIn(2))
            Label10.Text = TrackBar1.Value
            Label11.Text = TrackBar2.Value
            CheckBox1.Enabled = True
            CheckBox2.Enabled = True
            CheckBox3.Enabled = True
            CheckBox4.Enabled = True
            CheckBox5.Enabled = True
            CheckBox6.Enabled = True
            CheckBox7.Enabled = True
            CheckBox8.Enabled = True
            StatusLB2.Text = "Dispositivo USB Conectado"
        End If
    End Sub

    '*****************************************************************
    ' a HID device has been unplugged...
    '*****************************************************************
    Public Sub OnUnplugged(ByVal pHandle As Integer)
        If hidGetVendorID(pHandle) = VendorID And hidGetProductID(pHandle) = ProductID Then
            hidSetReadNotify(hidGetHandle(VendorID, ProductID), False)
            ' ** YOUR CODE HERE **
            Pictureoff.Visible = True
            Pictureon.Visible = False
            TrackBar1.Enabled = False
            TrackBar2.Enabled = False
            Label8.Text = "AN0"
            Label8.Text = "AN1"
            Label10.Text = "CCP1"
            Label11.Text = "CCP2"
            PictureBox1.Visible = False
            PictureBox3.Visible = False
            PictureBox5.Visible = False
            PictureBox7.Visible = False
            CheckBox1.Enabled = False
            CheckBox2.Enabled = False
            CheckBox3.Enabled = False
            CheckBox4.Enabled = False
            CheckBox5.Enabled = False
            CheckBox6.Enabled = False
            CheckBox7.Enabled = False
            CheckBox8.Enabled = False

            StatusLB2.Text = "Dispositivo USB Desconectado"
        End If
    End Sub

    '*****************************************************************
    ' controller changed notification - called
    ' after ALL HID devices are plugged or unplugged
    '*****************************************************************
    Public Sub OnChanged()
        ' get the handle of the device we are interested in, then set
        ' its read notify flag to true - this ensures you get a read
        ' notification message when there is some data to read...
        Dim pHandle As Integer
        pHandle = hidGetHandle(VendorID, ProductID)
        hidSetReadNotify(hidGetHandle(VendorID, ProductID), True)
    End Sub

    '*****************************************************************
    ' on read event...
    '*****************************************************************
    Public Sub OnRead(ByVal pHandle As Integer)
        ' read the data (don't forget, pass the whole array)...
        Dim index As Byte

        If hidRead(pHandle, BufferIn(0)) Then
            ' ** YOUR CODE HERE **
            ' first byte is the report ID, e.g. BufferIn(0)
            ' the other bytes are the data from the microcontroller...

            If BufferIn(7) = 0 And BufferIn(8) = 0 Then
                '
                '   incomming ADC reading and PORTA status
                '   --------------------------------------
                ProgressBar1.Value = BufferIn(1) 'Display ADC results to
                ProgressBar2.Value = BufferIn(2) 'the progress bars
                '
                Label8.Text = Val(BufferIn(1))  'Display Progress bars
                Label9.Text = Val(BufferIn(2))  'Values
                '
                PictureBox1.Visible = BufferIn(3) 'Display PORTA
                PictureBox3.Visible = BufferIn(4) 'status to
                PictureBox5.Visible = BufferIn(5) 'the according
                PictureBox7.Visible = BufferIn(6) 'LEDs
            Else
                '
                '   Incomming data is a text string
                '   -------------------------------
                For index = 1 To BufferInSize   ' pass the whole array but skip (0)
                    If BufferIn(index) <> 0 Then ' valid data?
                        txtreception.AppendText(Chr(BufferIn(index)))
                    End If
                Next
                txtreception.Text += vbNewLine
                txtreception.Select(txtreception.Text.Length - 1, 0)
                txtreception.ScrollToCaret()
            End If


        End If
    End Sub
    Public Sub WriteSomeData()
        '   Use to send data to the USB bus.
        '   data must be store in BufferOut array
        '
        '   Actual structure:
        '   -----------------
        '       BufferOut(0) = Report id => always 0
        '       BufferOut(1) = PORTB  ' first data item, etc etc
        '       BufferOut(2) = HPWM slider1 MSB
        '       BufferOut(3) = HPWM slider1 LSB
        '       BufferOut(4) = HPWM slider2 MSB
        '       BufferOut(5) = HPWM slider2 LSB
        '       BufferOut(6) = n/a = 0
        '       BufferOut(7) = n/a = 0
        '       BufferOut(8) = n/a = 0
        BufferOut(0) = 0   ' first by is always the report ID
        BufferOut(6) = 0
        BufferOut(7) = 0
        BufferOut(8) = 0

        hidWriteEx(VendorID, ProductID, BufferOut(0)) ' send it
    End Sub
   
    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        txtreception.Clear()
    End Sub

    Private Sub TrackBar1_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TrackBar1.Scroll
        BufferOut(2) = (TrackBar1.Value) And 255    ' keep only 8 LSB
        BufferOut(3) = Int(TrackBar1.Value / 256)   ' keep only 8 MSB
        Label10.Text = TrackBar1.Value              ' display it
        WriteSomeData()                             ' send it
    End Sub

    Private Sub TrackBar2_Scroll(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TrackBar2.Scroll
        BufferOut(4) = (TrackBar2.Value) And 255    ' keep only 8 LSB
        BufferOut(5) = Int(TrackBar2.Value / 256)   ' keep only 8 MSB
        Label11.Text = TrackBar2.Value              ' display it
        WriteSomeData()                             ' send it
    End Sub

    Public Sub ActualizaPORTAB()
        Dim i As Integer

        BufferOut(1) = 0

        If CheckBox1.Checked = True Then
            PORTB(0) = 1
        Else
            PORTB(0) = 0
        End If

        If CheckBox2.Checked = True Then
            PORTB(1) = 1
        Else
            PORTB(1) = 0
        End If

        If CheckBox3.Checked = True Then
            PORTB(2) = 1
        Else
            PORTB(2) = 0
        End If

        If CheckBox4.Checked = True Then
            PORTB(3) = 1
        Else
            PORTB(3) = 0
        End If

        If CheckBox5.Checked = True Then
            PORTB(4) = 1
        Else
            PORTB(4) = 0
        End If

        If CheckBox6.Checked = True Then
            PORTB(5) = 1
        Else
            PORTB(5) = 0
        End If

        If CheckBox7.Checked = True Then
            PORTB(6) = 1
        Else
            PORTB(6) = 0
        End If

        If CheckBox8.Checked = True Then
            PORTB(7) = 1
        Else
            PORTB(7) = 0
        End If

        For i = 0 To 7
            BufferOut(1) = BufferOut(1) + (PORTB(i) * (2 ^ i))
        Next

        WriteSomeData()
    End Sub

    Private Sub CheckBox1_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox1.CheckedChanged
        ActualizaPORTAB()
    End Sub

    Private Sub CheckBox2_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox2.CheckedChanged
        ActualizaPORTAB()
    End Sub

    Private Sub CheckBox3_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox3.CheckedChanged
        ActualizaPORTAB()
    End Sub

    Private Sub CheckBox4_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox4.CheckedChanged
        ActualizaPORTAB()
    End Sub

    Private Sub CheckBox5_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox5.CheckedChanged
        ActualizaPORTAB()
    End Sub

    Private Sub CheckBox6_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox6.CheckedChanged
        ActualizaPORTAB()
    End Sub

    Private Sub CheckBox7_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox7.CheckedChanged
        ActualizaPORTAB()
    End Sub

    Private Sub CheckBox8_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CheckBox8.CheckedChanged
        ActualizaPORTAB()
    End Sub

    Private Sub Timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        StatusLB3.Text = DateAndTime.Now.ToString
    End Sub
End Class
